import pylab
import numpy as np

f = open('lat50w60s.csv', 'r')
data = np.genfromtxt(f, delimiter=';')
f.close() 
# Create variables with user-friendly names
temp  = data[1:,1]
salt  = data[1:,2]
prof = data[1:,0]
del(data) 


pylab.subplot(121)
pylab.plot(temp, prof, label='Temp')
xmin=min(temp); 
xmax=max(temp); 
pylab.xlim(xmin-((xmax-xmin)*0.05), xmax+((xmax-xmin)*0.05)); 
ymin=min(prof); 
ymax=max(prof); 
pylab.ylim(0, ymax+((ymax-ymin)*0.1)); 
pylab.xlabel('Temperatura ($^\circ$C)') 
pylab.ylabel('Profundidade (m)') 
pylab.title('Perfil de Temperatura')
pylab.grid(True) 
pylab.gca().invert_yaxis() 
pylab.legend(loc=4) 

pylab.subplot(122)
pylab.plot(salt, prof, label='Sal')
xmin=min(salt); 
xmax=max(salt); 
pylab.xlim(xmin-((xmax-xmin)*0.05), xmax+((xmax-xmin)*0.05)); 
ymin=min(prof); 
ymax=max(prof); 
pylab.ylim(0, ymax+((ymax-ymin)*0.1)); 
pylab.xlabel('Salinidade') 
pylab.ylabel('Profundidade (m)') 
pylab.title('Perfil de Salinidade')
pylab.grid(True) 
pylab.gca().invert_yaxis() 
pylab.legend(loc=3) 



pylab.show()