import pylab
import numpy as np

f = open('lat14w30s.csv', 'r')
data = np.genfromtxt(f, delimiter=';')
f.close() 
# Create variables with user-friendly names
temp  = data[1:,1]
salt  = data[1:,2]
prof = data[1:,0]
oxi = data[1:,3]
del(data) 

pylab.title('Estacao 14 W 30 S')
pylab.subplot(131)
pylab.plot(temp, prof, label='Temp')
xmin=min(temp); 
xmax=max(temp); 
pylab.xlim(xmin-((xmax-xmin)*0.05), xmax+((xmax-xmin)*0.05)); 
ymin=min(prof); 
ymax=max(prof); 
pylab.ylim(0, ymax+((ymax-ymin)*0.1)); 
pylab.xlabel('Temperatura ($^\circ$C)') 
pylab.ylabel('Profundidade (m)') 
pylab.title('Perfil de Temperatura')
pylab.grid(True) 
pylab.gca().invert_yaxis() 
pylab.legend(loc=4) 

pylab.subplot(132)
pylab.plot(salt, prof, label='Sal')
xmin=min(salt); 
xmax=max(salt); 
pylab.xlim(xmin-((xmax-xmin)*0.05), xmax+((xmax-xmin)*0.05)); 
ymin=min(prof); 
ymax=max(prof); 
pylab.ylim(0, ymax+((ymax-ymin)*0.1)); 
pylab.xlabel('Salinidade') 
pylab.ylabel('Profundidade (m)') 
pylab.title('Perfil de Salinidade')
pylab.grid(True) 
pylab.gca().invert_yaxis() 
pylab.legend(loc=3) 

pylab.subplot(133)
pylab.plot(oxi, prof, label='Oxigenio')
xmin=min(oxi); 
xmax=max(oxi); 
pylab.xlim(xmin-((xmax-xmin)*0.05), xmax+((xmax-xmin)*0.05)); 
ymin=min(prof); 
ymax=max(prof); 
pylab.ylim(0, ymax+((ymax-ymin)*0.1)); 
pylab.xlabel('Oxigenio') 
pylab.ylabel('Profundidade (m)') 
pylab.title('Perfil de Oxigenio Dissolvido')
pylab.grid(True) 
pylab.gca().invert_yaxis() 
pylab.legend(loc=3) 

pylab.show()