import numpy as np
import seawater as gsw
import matplotlib.pyplot as plt
 
# importa os dados do arquivo *********************************
f = open('lat19w35s.csv', 'r')
data = np.genfromtxt(f, delimiter=';')
f.close() 
# Create variables with user-friendly names
temp  = data[1:,1]
salt  = data[1:,2]
oxi = data[1:,3]
# Figure out boudaries (mins and maxs)
smin = salt.min() - (0.01 * salt.min())
smax = salt.max() + (0.01 * salt.max())
tmin = temp.min() - (0.1 * temp.max())
tmax = temp.max() + (0.1 * temp.max())
# maximos e minimos oxigenio
omin = oxi.min()
omax = oxi.max()
ogap = (omax - omin) / 5; 
# Calculate how many gridcells we need in the x and y dimensions
xdim = round((smax-smin)/0.1+1,0)
ydim = round((tmax-tmin)+1,0)
print (smin) 
print (smax) 
print (tmin)
print (tmax)
print (omin)
print (omax)
print (ogap)
# Create empty grid of zeros
dens = np.zeros((ydim,xdim))
# Create temp and salt vectors of appropiate dimensions
ti = np.linspace(1,ydim-1,ydim)+tmin
si = np.linspace(1,xdim-1,xdim)*0.1+smin
# Loop to fill in grid with densities
for j in range(0,int(ydim)):
    for i in range(0, int(xdim)):
        dens[j,i]=gsw.dens(si[i],ti[j],0)
# Substract 1000 to convert to sigma-t
dens = dens - 1000
# Plot data ***********************************************
fig1 = plt.figure()
ax1 = fig1.add_subplot(111)
CS = plt.contour(si,ti,dens, linestyles='dashed', colors='k')
plt.clabel(CS, fontsize=12, inline=1, fmt='%1.0f') # Label every second level
# inclusao oxigenio
for ox in data:
	if(ox[1] >= 5 and ox[1] <= 18.35 and ox[2] >=34.52 and ox[2] <= 36.4):
		l1, = ax1.plot(ox[2],ox[1],'ok',markersize=8)
	else:
		if(ox[1] > 4.92 and ox[1] <= 5 and ox[2] >=34.48 and ox[2] <= 34.78):
			l2, = ax1.plot(ox[2],ox[1],'og',markersize=8)
		else:
			if(ox[1] >= 5.95 and ox[1] <= 18.35 and ox[2] >=34.52 and ox[2] <= 36.4):
				l3, = ax1.plot(ox[2],ox[1],'oc',markersize=8)
			else:
				if(ox[1] >= 5.95 and ox[1] <= 18.35 and ox[2] >=34.52 and ox[2] <= 36.4):
					l4,= ax1.plot(ox[2],ox[1],'oy',markersize=8)
								
# define legendas ***********************************************
ax1.legend( (l1, l2, l3, l4),
 ("acas",
  "AIA",
 "APAN",
 "AAF"),
 'upper left', shadow=True)
ax1.set_xlabel('Salinity')
ax1.set_ylabel('Temperature (C)')
plt.title('TS Estacao 19w 35 S')
plt.show()