#define PIN_TRIG 8
#define PIN_ECO  9
#define DHTPIN 7
#define DHTTYPE DHT22

#include <Narcoleptic.h>
#include <Wire.h>
#include <Adafruit_BMP085.h>
#include<DHT.h>
#include <SPI.h> //cartao memoria
#include <SD.h>   //cartaoemmoria
#include <DS1307.h>//RELOGIO
#include <OneWire.h>//temperatura ds18b20
//------------------wind ---------------------------------
#define uint  unsigned int
#define ulong unsigned long

#define PIN_ANEMOMETER  2     // Digital 2
#define PIN_VANE        0     // Analog 0

// How often we want to calculate wind speed or direction
#define MSECS_CALC_WIND_SPEED 5000
#define MSECS_CALC_WIND_DIR   5000

volatile int numRevsAnemometer = 0; // Incremented in the interrupt
ulong nextCalcSpeed;                // When we next calc the wind speed
ulong nextCalcDir;                  // When we next calc the direction
ulong time;                         // Millis() at each start of loop().

// ADC readings:
#define NUMDIRS 8

// These directions match 1-for-1 with the values in adc, but
// will have to be adjusted as noted above. Modify 'dirOffset'
// to which direction is 'away' (it's West here).
byte dirOffset = 0;

//--------------------------------------------------------
DHT dht(DHTPIN, DHTTYPE);
Adafruit_BMP085 bmp;
//Modulo RTC DS1307 ligado as portas A4 e A5 do Arduino
DS1307 rtc(A2, A3);
OneWire ds(5);
float umid, temp;
//File myFile;

void setup()
{
  Serial.begin(9600);
  //eco
  pinMode(PIN_TRIG, OUTPUT);
  pinMode(PIN_ECO, INPUT);
  //Aciona o relogio
  rtc.halt(false);
  //As linhas abaixo setam a data e hora do modulo
  //e podem ser comentada apos a primeira utilizacao
  //rtc.setDOW(FRIDAY);      //Define o dia da semana
  //rtc.setTime(02, 06, 00);     //Define o horario
  //rtc.setDate(29, 8, 2015);   //Define o dia, mes e ano

  //Definicoes do pino SQW/Out
  //rtc.setSQWRate(SQW_RATE_1);
  //rtc.enableSQW(true);

  dht.begin();
  bmp.begin();
  //pinMode(10, OUTPUT);
  //digitalWrite(10, HIGH);
  if (!SD.begin(4))
  {
    Serial.println("initialization failed!");
    return;
  }
  Serial.println("initialization done.");
  //------------------vento -------------------------------------
  pinMode(PIN_ANEMOMETER, INPUT);
  digitalWrite(PIN_ANEMOMETER, HIGH);
  attachInterrupt(0, countAnemometer, FALLING);
  nextCalcSpeed = millis() + MSECS_CALC_WIND_SPEED;
  nextCalcDir   = millis() + MSECS_CALC_WIND_DIR;
}
//-----------------------------------------------------------------------------------------------
char enviar[64], envU[10], envT[10], ponto[] = ";", *e, enter[]="\n";
int plumin;
long duracao, dist;
char* wd;
  float velVento;
  File arqLog;
  ulong dlay,tdlay;
void loop()
{
  strcpy(enviar, "");
  //-------------------PEGA DATA/HORA------------------------------
  strcat(enviar,rtc.getDateStr(FORMAT_SHORT));
  strcat(enviar, ponto);
  strcat(enviar,rtc.getTimeStr());
  strcat(enviar, ponto);
  //--------------------Piranômetro
  plumin = map(analogRead(1), 5, 1023, 0, 500);
  dtostrf(plumin, 4, 2, envT);
  strcat(enviar, envT);
  strcat(enviar, ponto);
  //---------------------- Neve Acumulada -----------------------
  digitalWrite(PIN_TRIG, LOW);
  delayMicroseconds(2);
  digitalWrite(PIN_TRIG, HIGH);  // Flanco ascendente
  delayMicroseconds(10);        // Duracion del pulso
  digitalWrite(PIN_TRIG, LOW);  // Flanco descendente
  /* Recepcion del eco de respuesta */
  duracao = pulseIn(PIN_ECO, HIGH);
  /* Calculo de la distancia efectiva */
  dist = (duracao / 2) / 29;
  dtostrf(dist, 4, 2, envT);
  strcat(enviar, envT);
  strcat(enviar, ponto);
  //---------------------- Temperatura neve ----------------------
  float tNeve = getTemp();
  dtostrf(tNeve, 4, 2, envT);
  strcat(enviar, envT);
  strcat(enviar, ponto);
  //---------------------- Vento --------------------------------
  time = millis();

  dlay = millis();
  tdlay = millis();
  velVento = calcWindSpeed();
  while(tdlay-dlay < 5000 )
    tdlay = millis();
  velVento = calcWindSpeed();
  dtostrf(velVento, 4, 2, envT);
  strcat(enviar, envT);
  strcat(enviar, ponto);
  wd = calcWindDir();
  strcat(enviar, wd);
  strcat(enviar, ponto);

  //---------------------- UMIDADE TEMPERATURA -------------------
  umid = dht.readHumidity();
  temp = dht.readTemperature();
  dtostrf(umid, 4, 2, envU);
  dtostrf(temp, 4, 2, envT);
  strcat(enviar, envU);
  strcat(enviar, ponto);
  strcat(enviar, envT);
  strcat(enviar, ponto);
  //----------------barometro--------------------------------------------

  dtostrf(bmp.readTemperature(), 4, 2, envT);
  strcat(enviar, envT);
  strcat(enviar, ponto);
  dtostrf((float)(bmp.readPressure() / 100), 4, 0, envU);
  strcat(enviar, envU);
  strcat(enviar, enter);
  //--------------------Logger---------------------------------------------
  arqLog = SD.open("arqLog.txt", FILE_WRITE);
  if (arqLog) {
    arqLog.print(enviar);
    arqLog.flush();
    arqLog.close();
  } else {
    Serial.println("nao gravou");
  }
  Serial.println(enviar);
  Narcoleptic.delay(600000);
}//FIM LOOP
// leitura da temperatura neve----------------------------------------------------
float getTemp() {

  byte data[12];
  byte addr[8];
  if ( !ds.search(addr)) {
    //no more sensors on chain, reset search
    ds.reset_search();
    return -1000;
  }
  if ( OneWire::crc8( addr, 7) != addr[7]) {
    Serial.println("CRC is not valid!");
    return -1000;
  }
  if ( addr[0] != 0x10 && addr[0] != 0x28) {
    Serial.print("Device is not recognized");
    return -1000;
  }
  ds.reset();
  ds.select(addr);
  ds.write(0x44, 1);
  byte present = ds.reset();
  ds.select(addr);
  ds.write(0xBE);

  for (int i = 0; i < 9; i++) {
    data[i] = ds.read();
  }

  ds.reset_search();

  byte MSB = data[1];
  byte LSB = data[0];
  float TRead = ((MSB << 8) | LSB);
  float Temperature = TRead / 16;

  return Temperature;

}
//=======================================================
// Interrupt handler for anemometer. Called each time the reed
// switch triggers (one revolution).
//=======================================================
void countAnemometer() {
  numRevsAnemometer++;
}
//=======================================================
// Find vane direction.
//=======================================================
char* calcWindDir() {
  ulong   adc[NUMDIRS] = {35, 55, 80, 120, 155, 195, 210, 225};
  char *strVals[NUMDIRS] = {"E", "SE", "S", "NE", "SW", "N", "NW", "W"};
  int val;
  byte x, reading;
  char r[6];
  val = analogRead(PIN_VANE);
  val >>= 2;                       // Shift to 255 range
  reading = val;
  //Serial.print("readind: ");
  //Serial.println(reading);
  for (x = 0; x < NUMDIRS; x++) {
    if (adc[x] >= reading)
      break;
  }
  x = (x + dirOffset) % 8;   // Adjust for orientation
  return (strVals[x]);
}
//=======================================================
// Calculate the wind speed, and display it (or log it, whatever).
// 1 rev/sec = 1.492 mph = 2.40114125 kph
//=======================================================
float calcWindSpeed() {
  int x, iSpeed;
  float t;
  // This will produce kph * 10
  // (didn't calc right when done as one statement)
  long speed = 24011;
  speed *= numRevsAnemometer;
  speed /= MSECS_CALC_WIND_SPEED;
  iSpeed = speed;         // Need this for formatting below
  x = iSpeed / 10;
  t = (float)iSpeed / 10;
  numRevsAnemometer = 0;        // Reset counter
  return (t);
}

