#include <DS1307.h>
#include <SPI.h> //cartao memoria
#include <SD.h>   //cartaoemmoria
#include <Narcoleptic.h>
#define resetRFID 8 //Define resetRFID como 8
#define powerRFID 9
#define ledOK 7
//Modulo RTC DS1307 ligado as portas A4 e A5 do Arduino 
DS1307 rtc(A2, A3);
String tag_lida =     "0000000000000",
       tag_anterior = "0000000000000"; //Cria a variável tag_lida e "limpa" as posições da ID

File arqLog, arqID;                             
int i, marca=-1; //Variável para contagem
long millsAt, millsAnt;

void setup()
{
  rtc.halt(false);
  //rtc.setDOW(WEDNESDAY);      //Define o dia da semana
  //rtc.setTime(11, 30, 00);     //Define o horario
  //rtc.setDate(28, 9, 2016);   //Define o dia, mes e ano
  rtc.setSQWRate(SQW_RATE_1);
  rtc.enableSQW(true);
  Serial.begin(9600); //Inicia a serial com um baud rate de 9600
  pinMode(resetRFID, OUTPUT); //Configura o pino D8 como saída 
  pinMode(powerRFID, OUTPUT); //Configura o pino D9 como saída
  pinMode(ledOK, OUTPUT);
  digitalWrite(ledOK, LOW);
  digitalWrite(powerRFID, HIGH);
  pinMode(4,OUTPUT);
  if (!SD.begin(4))
  {
    while(true){
      digitalWrite(ledOK, HIGH);
      delay(400);
      digitalWrite(ledOK, LOW);
      delay(500);
      }
  }
  digitalWrite(resetRFID, LOW); //Coloca o pino de reset do módulo ID12/20 em nível baixo(resetRFID, LOW);
  delay(5); //Aguarda 5 milissegundos
  digitalWrite(resetRFID, HIGH); //Coloca o pino de reset do módulo ID12/20 em nível alto(resetRFID, HIGH);
  delay(5); //Aguarda 5 milissegundos
  digitalWrite(ledOK, HIGH);
  delay(500);
  digitalWrite(ledOK, LOW);
  delay(500);
  digitalWrite(ledOK, HIGH);
  delay(4000);
  digitalWrite(ledOK, LOW);
  
  millsAnt = millis();
}
char enviar[64],ponto[] = ";",envT[10], enter[]="\n";

void loop ()
{        
  limpa_tag();
  if(Serial.available() > 0){ //Se a serial receber dados (ID)
    le_tag(); //Executa a função de leitura da TAG
   if(!tag_lida.equals(tag_anterior)){
    marca = identifica_tag();
    if(marca != 666){
      tag_anterior = tag_lida;
      strcpy(enviar, "");     
  //-------------------PEGA DATA/HORA------------------------------
      strcat(enviar,rtc.getDateStr(FORMAT_SHORT));
      strcat(enviar, ponto);
      strcat(enviar,rtc.getTimeStr());
      strcat(enviar, ponto);
 //-------------------pega marca------------------------------ 
      dtostrf(marca, 4, 2, envT);   
      strcat(enviar,envT);
      strcat(enviar, enter);
//---------------------logger-------------------------------------
      arqLog = SD.open("arqLog.txt", FILE_WRITE);
      if (arqLog) {
         arqLog.print(enviar);
         arqLog.flush();
         arqLog.close();
       } 
      }
    } 
  }
  millsAt = millis();
  if(millsAt - millsAnt > 20000){
     digitalWrite(powerRFID, LOW);
     Narcoleptic.delay(600000);
     digitalWrite(powerRFID, HIGH);
     delay(500);
     millsAnt = millis();
  }  
  delay(500);
}

 
int identifica_tag(){

char tag_stream[13],b;
int x=0,y,sim=666,j;
boolean flag = true;
arqID = SD.open("GI.TXT");
if (arqID) {
x=0;
while(arqID.available()){
  b = arqID.read();
  j=0;
  while(b != '\n'){ 
    tag_stream[j]= b;
    j++;
    b = arqID.read();
  }
  flag = true;

  for(y=0;y<13;y++){
    if(tag_lida[y+1] != tag_stream[y])
       flag = false;
  }
    if(flag){
      sim = x;
      return sim;
    }   
  x++;        
}
  arqID.close(); 
}
 return sim; 
}
 

void le_tag() //Função que lê a TAG e armazena a ID da TAG na variável tag_lida
{
i=0; //Zera a variável para leitura
while(Serial.available() > 0) //Enquanto a Serial receber dados (ID)
  {
    tag_lida[i] = Serial.read(); //Armazena o caractere que entrou na serial na posição da tag_lida
    i++; //Incrementa a variável de contagem
  }

}
void limpa_tag() //Função que limpa a variável tag_lida e reseta o módulo ID12/20 para nova leitura
{
  digitalWrite(resetRFID, LOW); //Coloca o pino de reset do módulo ID12/20 em nível baixo
  delay(5); //Aguarda 5 milissegundos
  digitalWrite(resetRFID, HIGH); //Coloca o pino de reset do módulo ID12/20 em nível alto
  delay(5); //Aguarda 5 milissegundos
for(i=0;i<13;i++) tag_lida[i] = '0'; //Laço para limpar todas as posições da variável tag_lida
}

 

 

